<?php

namespace App\Http\Requests\V1\Countries;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class StoreCountryRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-countries');
    }
    
    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string', 'max:255'],
            'name_ar' => ['required', 'string', 'max:255'],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}