<?php

namespace App\Http\Requests\V1\Countries;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class ChangeStatusCountryRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-countries');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}