<?php

namespace App\Http\Requests\V1\Contacts;

use App\Http\Requests\BaseFormRequest;

class StoreContactRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', 'max:255'],
            'phone' => ['nullable', 'string', 'max:20'],
            'message' => ['nullable', 'string'],
        ];
    }
}

