<?php

namespace App\Http\Requests\V1\Cities;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Enum;

class StoreCityRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-cities');
    }

    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string'],
            'name_ar' => ['required', 'string'],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
            'state_id' => ['required', 'integer', Rule::exists('states', 'id')],
        ];
    }
}
