<?php

namespace App\Http\Requests\V1\Cities;

use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class ChangeStatusCityRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('update-cities');
    }

    public function rules(): array
    {
        return [
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
        ];
    }
}
