<?php

namespace App\Http\Requests\V1\Categories;

use App\Enums\CategoryTypeEnum;
use App\Enums\StatusEnum;
use App\Http\Requests\BaseFormRequest;
use Illuminate\Support\Facades\Gate;
use Illuminate\Validation\Rules\Enum;

class StoreCategoryRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return Gate::allows('create-categories');
    }

    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string'],
            'name_ar' => ['required', 'string'],
            'description_en' => ['required', 'string'],
            'description_ar' => ['required', 'string'],
            'status' => ['required', 'boolean', new Enum(StatusEnum::class)],
            'home_status' => ['required', 'boolean', new Enum(StatusEnum::class)],
            'footer_visibility' => ['nullable', 'boolean', new Enum(StatusEnum::class)],
            'image' => ['required', 'image', 'mimes:jpg,png,jpeg'],
        ];
    }
}
