<?php

namespace App\Http\Requests\V1\Blogs;

use App\Http\Requests\BaseFormRequest;

class StoreBlogRequest extends BaseFormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name_en' => ['required', 'string', 'max:255'],
            'name_ar' => ['required', 'string', 'max:255'],
            'title_en' => ['required', 'string', 'max:255'],
            'title_ar' => ['required', 'string', 'max:255'],
            'description_en' => ['required', 'string'],
            'description_ar' => ['required', 'string'],
            'images' => ['required', 'array', 'max:' . config('general.project_image_limit')],
            'images.*' => ['file', 'mimes:jpeg,jpg,png,gif', 'max:5120'],
            'meta_title_en' => ['nullable', 'string', 'max:255'],
            'meta_title_ar' => ['nullable', 'string', 'max:255'],
            'alt_image_en' => ['nullable', 'string', 'max:255'],
            'alt_image_ar' => ['nullable', 'string', 'max:255'],
            'meta_description_en' => ['nullable', 'string'],
            'meta_description_ar' => ['nullable', 'string'],
        ];
    }
}
