<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest as FormRequest;
use Illuminate\Support\Str;

class BaseFormRequest extends FormRequest
{
    public function validatedInCamelCase(): array
    {
        return collect($this->validated())->mapWithKeys(function ($value, $key) {
            return [Str::camel($key) => $value];
        })->toArray();
    }
}
