<?php

namespace App\Http\Middleware;

use App\Enums\AppEnvironmentEnum;
use Closure;
use Illuminate\Support\Facades\App;
use Illuminate\Validation\UnauthorizedException;

class SecuritySignatureMiddleware
{
    public function handle($request, Closure $next)
    {
        if (App::environment(AppEnvironmentEnum::LOCAL->value) ||
            (App::environment(AppEnvironmentEnum::STAGING->value) && $request->header('purpose') == 'test')) {
            return $next($request);
        }
        if (!$request->hasHeader('signature') || !hash_equals($request->header('signature'), $this->hashedConcatRequestInputs($request->all()))) {
            throw new UnauthorizedException(trans('messages.something_wrong'));
        }
        return $next($request);
    }

    private function hashedConcatRequestInputs(array $inputs): string
    {
        $concatString = '';
        foreach ($inputs as $key => $value) {
            if (is_array($value)) {
                $concatString .= $key . '.' . $this->convertedValueFromArrayToString($value);
                continue;
            }
            $concatString .= $key . '.' . $value . '.';
        }
        return openssl_encrypt($concatString, 'aes-128-ecb', config('secrets.signature_key'));
    }

    private function convertedValueFromArrayToString(array $keyValue): string
    {
        $isAssociative = isArrayAssociative($keyValue);
        $concatString = '';
        foreach ($keyValue as $index => $value) {
            if (!$isAssociative) {
                $concatString .= $value . '.';
                continue;
            }
            $concatString .= $index . '.' . $value . '.';
        }
        return $concatString;
    }
}
