<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class Localization
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ($request->hasHeader('Accept-Language') && $request->header('Accept-Language') != App::getLocale() && in_array($request->header('Accept-Language'), config('app.available_locales'))) {
            App::setLocale($request->header('Accept-Language'));
        }
        return $next($request);
    }
}
