<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\States\ChangeStateStatusAction;
use App\Actions\V1\States\GetStateAction;
use App\Actions\V1\States\StateListAction;
use App\Actions\V1\States\StoreStateAction;
use App\Actions\V1\States\UpdateStateAction;
use App\Dto\V1\StateDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\States\ChangeStatusStateRequest;
use App\Http\Requests\V1\States\StoreStateRequest;
use App\Http\Requests\V1\States\UpdateStateRequest;
use App\Http\Resources\V1\StateResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\States\StatesUtility;
use App\Models\State;

class StateController
{
    public function index(ListingRequest $request, StateListAction $action, StatesUtility $utility): JsonResponse
    {
        Gate::authorize('view-states');
        return api_response(data: StateResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
    public function indexpaginated(ListingRequest $request, StateListAction $action, StatesUtility $utility): JsonResponse
    {
        Gate::authorize('view-states');
    
        return api_response(
            data: StateResource::collection(
                $action->executeWithPagination($utility, $request->getLimit())
            ),
            message: __('general.success_request')
        );
    }


    public function getById(int $id, GetStateAction $action): JsonResponse
    {
        Gate::authorize('view-states');
        return api_response(data: StateResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
    public function indexnotauth(ListingRequest $request, StateListAction $action, StatesUtility $utility): JsonResponse
    {
        return api_response(data: StateResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getByIdnotauth(int $id, GetStateAction $action): JsonResponse
    {
        return api_response(data: StateResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
    public function store(StoreStateRequest $request, StoreStateAction $action): JsonResponse
    {
        return api_response(data: StateResource::make($action->execute(new StateDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateStateRequest $request, UpdateStateAction $action): JsonResponse
    {
        $action->execute(new StateDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusStateRequest $request, ChangeStateStatusAction $action): JsonResponse
    {
        $action->execute(new StateDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
        public function destroy(int $id): JsonResponse
    {
         Gate::authorize('delete-states');
    
        $state = State::findOrFail($id);
        $state->delete();
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
