<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Sliders\ChangeSliderStatusAction;
use App\Actions\V1\Sliders\GetSliderAction;
use App\Actions\V1\Sliders\SliderListAction;
use App\Actions\V1\Sliders\StoreSliderAction;
use App\Actions\V1\Sliders\UpdateSliderAction;
use App\Dto\V1\SliderDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Sliders\ChangeStatusSliderRequest;
use App\Http\Requests\V1\Sliders\StoreSliderRequest;
use App\Http\Requests\V1\Sliders\UpdateSliderRequest;
use App\Http\Resources\V1\SliderResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Sliders\SlidersUtility;
use App\Models\Slider;

class SliderController
{
    
    public function index(ListingRequest $request, SliderListAction $action, SlidersUtility $utility): JsonResponse
    {
        Gate::authorize('view-sliders');
        return api_response(data: SliderResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
     public function indexnotauth(ListingRequest $request, SliderListAction $action, SlidersUtility $utility): JsonResponse
    {
        return api_response(data: SliderResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
     public function getByIdnotauth(int $id, GetSliderAction $action): JsonResponse
    {
        return api_response(data: SliderResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function getById(int $id, GetSliderAction $action): JsonResponse
    {
        Gate::authorize('view-sliders');
        return api_response(data: SliderResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreSliderRequest $request, StoreSliderAction $action): JsonResponse
    {
        return api_response(data: SliderResource::make($action->execute(new SliderDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateSliderRequest $request, UpdateSliderAction $action): JsonResponse
    {
        $action->execute(new SliderDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusSliderRequest $request, ChangeSliderStatusAction $action): JsonResponse
    {
        $action->execute(new SliderDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
        public function destroy(int $id): JsonResponse
    {
        Gate::authorize('delete-sliders'); // authorization
    
        $slider = Slider::findOrFail($id);
        $slider->delete();
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
