<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Settings\ChangeSettingStatusAction;
use App\Actions\V1\Settings\GetSettingAction;
use App\Actions\V1\Settings\SettingListAction;
use App\Actions\V1\Settings\StoreSettingAction;
use App\Actions\V1\Settings\UpdateSettingAction;
use App\Dto\V1\SettingDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Settings\ChangeStatusSettingRequest;
use App\Http\Requests\V1\Settings\StoreSettingRequest;
use App\Http\Requests\V1\Settings\UpdateSettingRequest;
use App\Http\Resources\V1\SettingResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Settings\SettingsUtility;

class SettingController
{
    
    public function index(ListingRequest $request, SettingListAction $action, SettingsUtility $utility): JsonResponse
    {
        Gate::authorize('view-states');
        return api_response(data: SettingResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
    public function indexnotauth(ListingRequest $request, SettingListAction $action, SettingsUtility $utility): JsonResponse {
        
        return api_response(
            data: SettingResource::collection(
                $action->executeWithoutPagination($utility)
            ),
            message: __('general.success_request')
        );
    }
    public function getById(int $id, GetSettingAction $action): JsonResponse
    {
        Gate::authorize('view-states');
        return api_response(data: SettingResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
    
     public function getByIdnotauth(int $id, GetSettingAction $action): JsonResponse
    {
        return api_response(data: SettingResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    // public function update(int $id, UpdateSettingRequest $request, UpdateSettingAction $action): JsonResponse
    // {
    //     $action->execute(new SettingDto(...$request->validatedInCamelCase()), $id);
    //     return api_response(message: __('general.success_request'));
    // }
    
    public function update(UpdateSettingRequest $request, UpdateSettingAction $action): JsonResponse
{
    $action->execute(
        new SettingDto(...$request->validatedInCamelCase())
    );

    return api_response(message: __('general.success_request'));
}

}
