<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Service\CreateServiceAction;
use App\Actions\V1\Service\GetServiceAction;
use App\Actions\V1\Service\UpdateServiceAction;
use App\Actions\V1\Service\DeleteServiceAction;
use App\Actions\V1\list\ServiceListAction;
use App\Http\Requests\V1\ServiceRequest;
use App\Http\Resources\V1\ServiceResource;
use App\Http\Resources\V1\ServiceCollection;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests\ListingRequest;
use App\Models\Service;

class ServiceController
{
    public function index(ListingRequest $request, ServiceListAction $serviceListAction): JsonResponse
    {
        $services = $serviceListAction->execute($request->getLimit());
        return api_response(ServiceCollection::make($services), message: __('general.success_request'));
    }

    
    public function indexnotauth(ListingRequest $request, ServiceListAction $serviceListAction): JsonResponse
    {
        $services = $serviceListAction->execute($request->getLimit());
        return api_response(ServiceCollection::make($services), message: __('general.success_request'));
    }

    public function store(ServiceRequest $request, CreateServiceAction $createServiceAction): JsonResponse
    {

        $service = $createServiceAction->execute($request->validated());
        return api_response(new ServiceResource($service), message: __('general.service_created'), status: 201);
    }

    public function show($id, GetServiceAction $getServiceAction): JsonResponse
    {
        $service = $getServiceAction->execute($id);
        return api_response(new ServiceResource($service), message: __('general.success_request'));
    }
    
    public function shownotauth($id, GetServiceAction $getServiceAction): JsonResponse
    {
        $service = $getServiceAction->execute($id);
        return api_response(new ServiceResource($service), message: __('general.success_request'));
    }

    public function update(ServiceRequest $request, $id, UpdateServiceAction $updateServiceAction): JsonResponse
    {

        $service = $updateServiceAction->execute($id, $request->validated());
        return api_response(new ServiceResource($service), message: __('general.service_updated'));
    }

       public function destroy($id): JsonResponse
    {
        $service = Service::findOrFail($id);
        $service->delete();
    
        return api_response(
            null,
            message: __('general.service_deleted'),
            status: 200
        );
    }
}
