<?php

namespace App\Http\Controllers\V1;
use Illuminate\Support\Facades\Gate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Actions\V1\Project\{
    ChangeProjectStatusAction,
    DeleteProjectImageAction,
    GetProfessionalProjectDetailsAction,
    GetProfessionalProjectsAction,
    GetProjectCommentsAction,
    GetProjectDetailsAction,
    GetSimilarProjectsAction,
    IndexProjectAction,
    StoreProjectAction,
    StoreProjectCommentAction,
    UpdateProjectAction,
    UploadImageAction,
    StoreBulkProjectAction,
    UploadImagesAction,
    IndexProjectNoPaginationAction

};
use App\Dto\V1\Project\ProjectCommentDto;
use App\Dto\V1\Project\ProjectDto;
use App\Dto\V1\Project\ProjectImagesDto;
use App\Dto\V1\Project\ProjectImageDto;
use App\Http\Requests\ListingRequest;
// use App\Http\Requests\V1\ListingRequest;
use App\Http\Requests\V1\Projects\{
    ChangeProjectStatusRequest,
    StoreProjectCommentRequest,
    StoreProjectRequest,
    UpdateProjectRequest,
    UploadImageRequest,
    StoreBulkProjectRequest,
    UploadImagesRequest
};
use App\Http\Resources\V1\Projects\{
    ProfessionalProjectDetailsResource,
    ProfessionalProjectResource,
    ProjectCommentResource,
    ProjectImageResource,
    ProjectResource
};
use Illuminate\Http\JsonResponse;
use Infrastructure\Services\Utilities\Projects\ProjectUtility;
use App\Http\Resources\V1\UserResource;
use App\Models\Project;


class ProjectController
{
     public function index(IndexProjectNoPaginationAction $action, ProjectUtility $utility): JsonResponse
        {
            return api_response(
                data: ProjectResource::collection($action->execute($utility)),
                message: __('general.success_request')
            );
        }
    public function indexwithauth(IndexProjectAction $indexProjectAction, ProjectUtility $utility): JsonResponse
    {
        return api_response(
            data: ProjectResource::collection($indexProjectAction->execute($utility)),
            message: __('general.success_request')
        );
    }
    
    public function indexWithPagination(IndexProjectAction $action, ProjectUtility $utility): JsonResponse {
        return api_response(data: ProjectResource::collection($action->execute($utility)),message: __('general.success_request'));
    }

    public function getProjectDetailswithauth(int $id, ListingRequest $request, GetProjectDetailsAction $getProjectDetailsAction, GetSimilarProjectsAction $getSimilarProjectsAction): JsonResponse
    {
        $project = $getProjectDetailsAction->execute($id);

        // $similar = $project->category_id ? ProjectResource::collection($getSimilarProjectsAction->execute($id, $project->category_id, $request->getLimit())) : [];

        return api_response(
            data: [
                'projectData' => ProjectResource::make($project),
                // 'similarProjects' => $similar,
            ],
            message: $project->category_id ? __('general.success_request') : __('general.project_has_no_category')
        );
    }

      public function getisliked()
    {
        $user = Auth::guard('website')->user();
    
        if (!$user) {
            return api_response(message: 'Unauthorized', code: 401);
        }
    
        
        $projects = $user->likes()->with('project')->get()->pluck('project');
    
        return api_response(
            data: ProjectResource::collection($projects),
            message: __('general.success_request')
        );
    }

    public function storeProject(StoreProjectRequest $request, StoreProjectAction $storeProjectAction): JsonResponse
    {
         Gate::authorize('create-projects');
        $storeProjectAction->execute(new ProjectDto(...$request->validatedInCamelCase()), auth()->user());
        return api_response(message: __('general.success_request'));
    }

    public function updateProject(int $id, UpdateProjectRequest $request, UpdateProjectAction $updateProjectAction): JsonResponse
    {

        $updateProjectAction->execute($id, new ProjectDto(...$request->validatedInCamelCase()), auth()->id());
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeProjectStatusRequest $request, ChangeProjectStatusAction $changeProjectStatusAction): JsonResponse
    {
        $changeProjectStatusAction->execute($id, new ProjectDto(...$request->validatedInCamelCase()), auth()->id());
        return api_response(message: __('general.success_request'));
    }

    public function deleteImage(int $id, DeleteProjectImageAction $deleteProjectImageAction): JsonResponse
    {
        $deleteProjectImageAction->execute($id, auth()->id());
        return api_response(message: __('general.success_request'));
    }

    public function getProfessionalProjects(GetProfessionalProjectsAction $getProfessionalProjectsAction, ProjectUtility $utility): JsonResponse
    {
        return api_response(
            data: ProfessionalProjectResource::collection($getProfessionalProjectsAction->execute($utility, auth()->id())),
            message: __('general.success_request')
        );
    }

    public function getProfessionalProjectDetails(int $id, GetProfessionalProjectDetailsAction $getProfessionalProjectDetailsAction): JsonResponse
    {
        return api_response(
            data: ProfessionalProjectDetailsResource::make($getProfessionalProjectDetailsAction->execute($id, auth()->id())),
            message: __('general.success_request')
        );
    }

    public function getProjectDetails(int $id, ListingRequest $request, GetProjectDetailsAction $getProjectDetailsAction, GetSimilarProjectsAction $getSimilarProjectsAction): JsonResponse
    {
        $project = $getProjectDetailsAction->execute($id);

        // $similar = $project->category_id ? ProjectResource::collection($getSimilarProjectsAction->execute($id, $project->category_id, $request->getLimit())) : [];

        return api_response(
            data: [
                'projectData' => ProjectResource::make($project),
                // 'similarProjects' => $similar,
            ],
            message: $project->category_id ? __('general.success_request') : __('general.project_has_no_category')
        );
    }

    public function uploadImage(UploadImageRequest $request, UploadImageAction $uploadImageAction): JsonResponse
    {
        return api_response(
            data: ProjectImageResource::collection($uploadImageAction->execute(new ProjectImageDto(...$request->validatedInCamelCase())))->resolve(),
            message: __('general.success_request')
        );
    }

    public function storeComment(int $id, StoreProjectCommentRequest $request, StoreProjectCommentAction $storeProjectCommentAction): JsonResponse
    {
        return api_response(
            data: ProjectCommentResource::make($storeProjectCommentAction->execute($id, auth()->id(), new ProjectCommentDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request')
        );
    }

    public function getProjectComments(int $id, ListingRequest $request, GetProjectCommentsAction $getProjectCommentsAction): JsonResponse
    {
        return api_response(
            data: ProjectCommentResource::collection($getProjectCommentsAction->execute($id, $request->getLimit())),
            message: __('general.success_request')
        );
    }

    public function storeBulk(StoreBulkProjectRequest $request, StoreBulkProjectAction $action): JsonResponse
    {
        $action->execute($request->validated()['projects'], auth()->user());
        return api_response(message: __('general.success_request'));
    }

    public function getProjectDetailsFromLikes(int $id, ListingRequest $request, GetProjectDetailsAction $getProjectDetailsAction, GetSimilarProjectsAction $getSimilarProjectsAction): JsonResponse
    {
        $project = $getProjectDetailsAction->execute($id);

        if ($project) {
            $similar = $project->category_id
                ? ProjectResource::collection(
                    $getSimilarProjectsAction->execute($id, $project->category_id, $request->getLimit())
                )
                : [];

            return api_response(data: [
                'projectData' => ProfessionalProjectDetailsResource::make($project),
                'similarProjects' => $similar,
            ], message: __('general.success_request'));
        }

        return api_response(data: [], message: __('general.project_not_found'), status: 404);
    }
    public function uploadImages(UploadImagesRequest $request, UploadImagesAction $uploadImagesAction): JsonResponse
    {
        return api_response(
            data: ProjectImageResource::collection($uploadImagesAction->execute(new ProjectImagesDto($request->file('images')))),
            message: __('general.success_request')
        );
    }
    
        public function destroy(int $id): JsonResponse
    {
         Gate::authorize('delete-projects'); // authorization
    
        $project = Project::findOrFail($id);
        $project->delete();
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
    
    
        public function changeHomeStatus(int $id, Request $request): JsonResponse
    {
        Gate::authorize('update-projects'); 
        
        if (!auth()->user()->hasRole('super-admin')) {

        return api_response(
            message: 'Unauthorized',
            status: 403
        );
       }
    
        $request->validate([
            'home_status' => 'required|boolean'
        ]);
    
        $project = Project::findOrFail($id);
    
        $project->home_status = $request->home_status;
        $project->save();
    
        return api_response(
            data: ProjectResource::make($project),
            message: __('general.success_request')
        );
    }
}
