<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Roles\GetRoleAction;
use App\Actions\V1\Roles\PermissionsListAction;
use App\Actions\V1\Roles\RolesListAction;
use App\Actions\V1\Roles\StoreRoleAction;
use App\Actions\V1\Roles\UpdateRoleAction;
use App\Dto\V1\RoleDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Roles\StoreRoleRequest;
use App\Http\Requests\V1\Roles\UpdateRoleRequest;
use App\Http\Resources\V1\PermissionGroupResource;
use App\Http\Resources\V1\RoleResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Roles\RolesUtility;
use Illuminate\Pagination\LengthAwarePaginator;
use Spatie\Permission\Models\Role;


class PermissionController
{
    public function index(PermissionsListAction $action): JsonResponse
    {
        Gate::authorize('view-roles');
        return api_response(data: PermissionGroupResource::collection($action->execute()),
            message: __('general.success_request'));
    }

    public function rolesIndex(ListingRequest $request, RolesListAction $action, RolesUtility $utility): JsonResponse
    {
        Gate::authorize('view-roles');
        return api_response(data: RoleResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }
    
    public function rolesIndexWithPaginate(ListingRequest $request, RolesListAction $action, RolesUtility $utility): JsonResponse
    {
        Gate::authorize('view-roles');
    
        return api_response(
            data: RoleResource::collection(
                $action->executeWithPagination($utility, $request->getLimit())
            ),
            message: __('general.success_request')
        );
    }



    public function getRoleById(int $id, GetRoleAction $action): JsonResponse
    {
        Gate::authorize('view-roles');
        return api_response(data: RoleResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function storeRole(StoreRoleRequest $request, StoreRoleAction $action): JsonResponse
    {
        return api_response(data: RoleResource::make($action->execute(new RoleDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function updateRole(int $id, UpdateRoleRequest $request, UpdateRoleAction $action): JsonResponse
    {
        return api_response(data: RoleResource::make($action->execute(new RoleDto(...$request->validatedInCamelCase()), $id)),
            message: __('general.success_request'));
    }
        
        public function destroy(int $id): JsonResponse
    {
         Gate::authorize('delete-roles'); // authorization
    
        $role = Role::findOrFail($id);
        $role->delete();
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
