<?php

namespace App\Http\Controllers\V1;

use App\Enums\UserStatusEnum;
use App\Enums\UserTypeEnum;
use App\Exceptions\LogicalException;
use App\Http\Resources\V1\LookupResource;
use App\Models\{Budget, Category, City, Country, Currency, DesignType, Label, PricingUnit, ProjectType, Service, State, Tag, User};
use Illuminate\Http\Request;

class LookupController
{
    /**
     * @throws LogicalException
     */
    public function lookup($entity, Request $request)
    {
        $model = $this->entityMapper($entity);

        if (!$model) {
            throw new LogicalException("Invalid Lookup {$entity}");
        }

        $query = $model::query();

        $customFilterMethod = 'filter' . ucfirst($entity);
        if (method_exists($this, $customFilterMethod)) {
            $this->$customFilterMethod($query, $request);
        }

        foreach ($request->all() as $key => $value) {
            if (in_array($key, $this->getModelColumns($model))) {
                if (is_array($value)) {
                    $query->whereIn($key, $value);
                } else {
                    $query->where($key, $value);
                }
            }
        }

        return api_response(data: LookupResource::collection($query->get()), message: __('general.success_request'));
    }

    protected function entityMapper($entity): ?string
    {
        $lookupEntities = [
            'categories' => Category::class,
            'states' => State::class,
            'cities' => City::class,
            'countries' => Country::class,
            'tags' => Tag::class,
            'professionals' => User::class,
            'labels' => Label::class,
            'currencies' => Currency::class,
        ];

        return $lookupEntities[$entity] ?? null;
    }

    protected function getModelColumns($model)
    {
        return (new $model)->getFillable();
    }

    protected function filterProfessionals($query)
    {
        $query->where('type', UserTypeEnum::PROFESSIONAL->value)
            ->where('status', UserStatusEnum::ACTIVE->value)
            ->when(request('category_id'), function ($q) {
                $q->whereRelation('details', 'category_id', '=', request('category_id'));
            });
    }
}
