<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\FooterTitles\FooterTitleListAction;
use App\Actions\V1\FooterTitles\ChangeFooterTitleStatusAction;
use App\Actions\V1\FooterTitles\GetFooterTitleAction;
use App\Actions\V1\FooterTitles\StoreFooterTitleAction;
use App\Actions\V1\FooterTitles\UpdateFooterTitleAction;
use App\Dto\V1\FooterTitleDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\FooterTitles\ChangeStatusFooterTitleRequest;
use App\Http\Requests\V1\FooterTitles\StoreFooterTitleRequest;
use App\Http\Requests\V1\FooterTitles\UpdateFooterTitleRequest;
use App\Http\Resources\V1\FooterTitleResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use Infrastructure\Services\Utilities\Footers\FooterTitlesUtility;
use App\Models\FooterTitle;


class FooterTitleController
{
    public function index(ListingRequest $request, FooterTitleListAction $action, FooterTitlesUtility $utility): JsonResponse
    {
        Gate::authorize('view-footers');
        return api_response(data: FooterTitleResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getById(int $id, GetFooterTitleAction $action): JsonResponse
    {
        Gate::authorize('view-footers');
        return api_response(data: FooterTitleResource::make($action->execute($id)),
            message: __('general.success_request'));
    }
    
    
    public function indexnotpaginated(FooterTitleListAction $action, FooterTitlesUtility $utility): JsonResponse
    {
        Gate::authorize('view-footers');
    
        return api_response(
            data: FooterTitleResource::collection($action->executeAll($utility)),
            message: __('general.success_request')
        );
    }


     public function indexnotauth(ListingRequest $request, FooterTitleListAction $action, FooterTitlesUtility $utility): JsonResponse
    {
        return api_response(data: FooterTitleResource::collection($action->execute($utility, $request->getLimit())),
            message: __('general.success_request'));
    }

    public function getByIdnotauth(int $id, GetFooterTitleAction $action): JsonResponse
    {
        return api_response(data: FooterTitleResource::make($action->execute($id)),
            message: __('general.success_request'));
    }

    public function store(StoreFooterTitleRequest $request, StoreFooterTitleAction $action): JsonResponse
    {
        return api_response(data: FooterTitleResource::make($action->execute(new FooterTitleDto(...$request->validatedInCamelCase()))),
            message: __('general.success_request'));
    }

    public function update(int $id, UpdateFooterTitleRequest $request, UpdateFooterTitleAction $action): JsonResponse
    {
        $action->execute(new FooterTitleDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusFooterTitleRequest $request, ChangeFooterTitleStatusAction $action): JsonResponse
    {
        $action->execute(new FooterTitleDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
        public function destroy(int $id): JsonResponse
    {
         Gate::authorize('delete-footers'); // authorization
    
        $footerTitle = FooterTitle::findOrFail($id);
        $footerTitle->delete(); // حذف عادي
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}
