<?php

namespace App\Http\Controllers\V1;

use App\Dto\V1\CountryDto;
use App\Http\Requests\V1\Countries\StoreCountryRequest;
use App\Http\Requests\V1\Countries\UpdateCountryRequest;
use App\Http\Requests\V1\Countries\ChangeStatusCountryRequest;
use App\Http\Resources\V1\CountryResource;
use App\Actions\V1\Countries\StoreCountryAction;
use App\Actions\V1\Countries\UpdateCountryAction;
use App\Actions\V1\Countries\ChangeCountryStatusAction;
use App\Actions\V1\Countries\GetCountryAction;
use App\Actions\V1\Countries\CountryListAction;
use Infrastructure\Services\Utilities\Countries\CountriesUtility;
use App\Http\Requests\ListingRequest;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;
use App\Models\Country;

class CountryController
{
    public function index(ListingRequest $request, CountryListAction $action, CountriesUtility $utility): JsonResponse
    {
        Gate::authorize('view-countries');
        return api_response(data: CountryResource::collection($action->execute($utility, $request->getLimit())), message: __('general.success_request'));
    }
    
    public function indexpaginated(ListingRequest $request, CountryListAction $action, CountriesUtility $utility): JsonResponse
    {
        Gate::authorize('view-countries');
    
        return api_response(
            data: CountryResource::collection(
                $action->executeWithPagination($utility, $request->getLimit())
            ),
            message: __('general.success_request')
        );
    }


    public function getById(int $id, GetCountryAction $action): JsonResponse
    {
        Gate::authorize('view-countries');
        return api_response(data: CountryResource::make($action->execute($id)), message: __('general.success_request'));
    }
    
        public function indexnotauth(ListingRequest $request, CountryListAction $action, CountriesUtility $utility): JsonResponse
    {
        return api_response(data: CountryResource::collection($action->execute($utility, $request->getLimit())), message: __('general.success_request'));
    }

    public function getByIdnotauth(int $id, GetCountryAction $action): JsonResponse
    {
        return api_response(data: CountryResource::make($action->execute($id)), message: __('general.success_request'));
    }


    public function store(StoreCountryRequest $request, StoreCountryAction $action): JsonResponse
    {
        return api_response(data: CountryResource::make($action->execute(new CountryDto(...$request->validatedInCamelCase()))), message: __('general.success_request'));
    }

    public function update(int $id, UpdateCountryRequest $request, UpdateCountryAction $action): JsonResponse
    {
        $action->execute(new CountryDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }

    public function changeStatus(int $id, ChangeStatusCountryRequest $request, ChangeCountryStatusAction $action): JsonResponse
    {
        $action->execute(new CountryDto(...$request->validatedInCamelCase()), $id);
        return api_response(message: __('general.success_request'));
    }
    
    
        public function destroy(int $id): JsonResponse
    {
        Gate::authorize('delete-countries');
    
        $country = Country::findOrFail($id);
        $country->delete();
    
        return api_response(
            null,
            message: __('general.success_request'),
            status: 200
        );
    }
}