<?php

namespace App\Http\Controllers\V1;

use App\Actions\V1\Blog\{
    BlogListAction,
    DeleteBlogAction,
    DeleteBlogImageAction,
    GetBlogAction,
    StoreBlogAction,
    UpdateBlogAction,
    UploadImageAction,
    UploadImagesAction,
    GetBlogWithRelatedAction
};
use App\Dto\V1\Blog\BlogImageDto;
use App\Dto\V1\Blog\BlogImagesDto;
use App\Dto\V1\BlogDto;
use App\Http\Requests\ListingRequest;
use App\Http\Requests\V1\Blogs\StoreBlogRequest;
use App\Http\Requests\V1\Blogs\UpdateBlogRequest;
use App\Http\Requests\V1\Blogs\UploadImageRequest;
use App\Http\Requests\V1\Blogs\UploadImagesRequest;
use App\Http\Resources\V1\Blogs\BlogImageResource;
use App\Http\Resources\V1\Blogs\BlogResource;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Gate;

class BlogController
{
    public function index(ListingRequest $request, BlogListAction $action): JsonResponse
    {
                Gate::authorize('view-blogs');

        return api_response(
            data: BlogResource::collection($action->execute($request->getLimit())),
            message: __('general.success_request')
        );
    }

    public function getById(int $id, GetBlogAction $action): JsonResponse
    {
                Gate::authorize('show-blog');

        return api_response(
            data: BlogResource::make($action->execute($id)),
            message: __('general.success_request')
        );
    }
    public function indexnotauth(ListingRequest $request, BlogListAction $action): JsonResponse
    {
        return api_response(
            data: BlogResource::collection($action->execute($request->getLimit())),
            message: __('general.success_request')
        );
    }

    public function getByIdnotauth(int $id, GetBlogWithRelatedAction $action): JsonResponse
    {
        $result = $action->execute($id, 6);
    
        return api_response(
            data: [
                'blog' => BlogResource::make($result['blog']),
                'relatedArticles' => BlogResource::collection($result['related']),
            ],
            message: __('general.success_request')
        );
    }

    public function storeBlog(StoreBlogRequest $request, StoreBlogAction $action): JsonResponse
    {
                Gate::authorize('create-blogs');

        $action->execute(new BlogDto(...$request->validatedInCamelCase()));
        return api_response(message: __('general.success_request'));
    }

    public function updateBlog(int $id, UpdateBlogRequest $request, UpdateBlogAction $action): JsonResponse
    {
                Gate::authorize('update-blogs');

        $action->execute($id, new BlogDto(...$request->validatedInCamelCase()));
        return api_response(message: __('general.success_request'));
    }

    public function delete(int $id, DeleteBlogAction $action): JsonResponse
    {
                Gate::authorize('delete-blogs');

        $action->execute($id);
        return api_response(message: __('general.success_request'));
    }

    public function deleteImage(int $id, DeleteBlogImageAction $action): JsonResponse
    {
                Gate::authorize('delete-blogs');

        $action->execute($id);
        return api_response(message: __('general.success_request'));
    }

    public function uploadImage(UploadImageRequest $request, UploadImageAction $action): JsonResponse
    {
                Gate::authorize('create-blogs');

        return api_response(
            data: BlogImageResource::collection($action->execute(new BlogImageDto(...$request->validatedInCamelCase())))->resolve(),
            message: __('general.success_request')
        );
    }

    public function uploadImages(UploadImagesRequest $request, UploadImagesAction $action): JsonResponse
    {
                Gate::authorize('create-blogs');

        return api_response(
            data: BlogImageResource::collection($action->execute(new BlogImagesDto($request->file('images')))),
            message: __('general.success_request')
        );
    }
}
