<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class WhatsAppLogsExport implements FromCollection, WithHeadings
{
    public function __construct(private Collection $logs)
    {
    }

    public function collection(): Collection
    {
        return $this->logs->map(function ($log) {
            return [
                'customer' => $log->customer?->name_en ?? '',
                'professional' => $log->professional?->name_en ?? '',
                'customer_phone' => $log->customer?->phone ?? '',
                'professional_phone' => $log->professional?->phone ?? '',
                'status' => $log->status == 1 ? 'New Lead' : "Follow Up" ,
                'clicked_at' => $log->click_timestamp?->toDateTimeString(),
            ];
        });
    }

   public function headings(): array
{
    return [
        'Customer',
        'Professional',
        'Customer Phone',
        'Professional Phone',
        'Status',
        'Click Timestamp',
    ];
}
}
