<?php

namespace App\Enums;

enum UserTypeEnum: int
{
    case CUSTOMER = 1;
    case PROFESSIONAL = 2;

    public static function getNameFromValue(int $value): string
    {
        return match ($value) {
            self::CUSTOMER->value => self::CUSTOMER->name,
            self::PROFESSIONAL->value => self::PROFESSIONAL->name,
        };
    }
}
