<?php

namespace App\Enums;

enum SliderPageEnum: int
{
    case HOME = 1;
    case PROFESSIONAL = 2;
    case SERVICE = 3;
    case JOIN_US = 4;

    public static function getNameByValue(int $value): string
    {
        return match ($value) {
            self::HOME->value => self::HOME->name,
            self::PROFESSIONAL->value => self::PROFESSIONAL->name,
            self::SERVICE->value => self::SERVICE->name,
            self::JOIN_US->value => self::JOIN_US->name,
        };
    }
}
