<?php

namespace App\Enums;

enum SettingsEnum: string
{
    case JOIN_US_IMAGE = 'join_us_image';
    case LOGO_EN = 'logo_en';
    case LOGO_AR = 'logo_ar';
    case MOBILE = 'mobile';
    case EMAIL = 'email';
    case ADDRESS_EN = 'address_en';
    case ADDRESS_AR = 'address_ar';
    case FACEBOOK = 'facebook';
    case LINKEDIN = 'linkedin';
    case INSTAGRAM = 'instagram';

    public static function getRulesFromValue(string $value): array
    {
        return match ($value) {
            self::JOIN_US_IMAGE->value,
            self::LOGO_EN->value,
            self::LOGO_AR->value => ['required', 'image', 'mimes:jpeg,jpg,png,gif', 'max:1024'],
            default => ['required', 'string'],
        };
    }

    public static function getValueFormatted(string $name, mixed $value): ?string
    {
        return match ($name) {
            self::JOIN_US_IMAGE->value,
            self::LOGO_EN->value,
            self::LOGO_AR->value => $value ? s3_images_url('settings/' . $value) : null,
            default => $value
        };
    }

    public static function getAllValues(): array
    {
        return [
            self::JOIN_US_IMAGE->value,
            self::LOGO_EN->value,
            self::LOGO_AR->value,
            self::MOBILE->value,
            self::EMAIL->value,
            self::ADDRESS_EN->value,
            self::ADDRESS_AR->value,
            self::FACEBOOK->value,
            self::LINKEDIN->value,
            self::INSTAGRAM->value,
        ];
    }
}
