<?php

namespace App\Enums\Project;

enum ProjectTypeEnum: int
{
    case PROJECT = 1;
    case IDEA_BOOK = 2;

    public static function getNameFromValue(int $value): string
    {
        return match ($value) {
            self::PROJECT->value => __('enums.' . self::PROJECT->name),
            self::IDEA_BOOK->value => __('enums.' . self::IDEA_BOOK->name),
        };
    }
}
