<?php

namespace App\Enums\Project;

enum ProjectStatusEnum: int
{
    case UNDER_REVIEW = 1;
    case PUBLISHED = 2;
    case READY_TO_PUBLISH = 3;
    case REJECTED = 4;

    public static function getNameFromValue(int $value): string
    {
        return match ($value) {
            self::UNDER_REVIEW->value => __('enums.' . self::UNDER_REVIEW->name),
            self::PUBLISHED->value => __('enums.' . self::PUBLISHED->name),
            self::REJECTED->value => __('enums.' . self::REJECTED->name),
            self::READY_TO_PUBLISH->value => __('enums.' . self::READY_TO_PUBLISH->name),
        };
    }

    public static function notReadyToPublishStatus(): array
    {
        return [
            self::UNDER_REVIEW->value,
            self::REJECTED->value,
        ];
    }
}
