<?php

namespace App\Enums\Project;

enum Condition: int
{
    case NEW = 1;           
    case USED = 2;         
    case UNDER_CONSTRUCTION = 3; 

    public function label(): string
    {
        return match($this) {
            self::NEW => 'new',
            self::USED => 'used',
            self::UNDER_CONSTRUCTION => 'under conustruction'
        };
    }

    public static function labels(): array
    {
        return collect(self::cases())->mapWithKeys(fn ($case) => [
            $case->value => $case->label()
        ])->toArray();
    }
}
