<?php

namespace App\Dto\V1\Project;

use Illuminate\Http\UploadedFile;

class ProjectImageDto
{
    /**
     * @param UploadedFile[] $images
     */
    public function __construct(
        public array $images,
    ) {}

    public function uploadImagePayload(): array
    {
        $paths = [];

        foreach ($this->images as $image) {
            if (! $image instanceof UploadedFile) {
                continue;
            }

            $paths[] = $image->store('projects', 'public');
        }

        return [
            'images' => $paths,
        ];
    }
}
