<?php

namespace App\Dto\V1\Project;

use App\Enums\Project\ProjectStatusEnum;
use App\Enums\Project\ProjectTypeEnum;
use Carbon\Carbon;


class ProjectDto
{
    public function __construct(
        public ?string $nameEn = null,
        public ?string $nameAr = null,
        public ?string $descriptionEn = null,
        public ?string $descriptionAr = null,
        public ?int    $type = null,
        public ?array  $images = [],
        public ?string $areaEn = null,
        public ?string $areaAr = null,
        public ?int $countryId = null,
        public ?int    $stateId = null,
        public ?int    $cityId = null,
        public ?int    $projectTypeId = null,
        public ?int    $designTypeId = null,
        public ?int    $budgetId = null,
        public ?int    $status = null,
        public ?int    $categoryId = null,
        public ?array $tags = [],
        public ?int $subCategoryId = null,
        public ?string $tiktokLink = null,
        public ?array $newImages = [],
        public ?array $removedImages = [],
        public ?float $price = null,
        public ?string $priceCurrency = null,
        public ?float $totalArea = null,
        public ?float $landArea = null,
        public ?float $builtArea = null,
        public ?int $totalFloors = null,
        public ?int $totalUnits = null,
        public ?string $handoverDate = null,
        public ?int $offerType = null,
        public ?int $condition = null,
        public ?bool $hasPool = null,
        public ?bool $hasGym = null,
        public ?bool $hasParking = null,
        public ?bool $furnished = null,
        public ?float $downPayment = null,
        public ?int $installmentsCount = null,
        public ?float $installmentAmount = null,
        public ?int $numberOfBathrooms = null,
        public ?int $numberOfRooms = null,
        public ?int $numberOfBeds = null,
        public ?int $sort = null,

     )
    {
    }

    public function projectStorePayload(int $userId): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'description_en' => $this->descriptionEn,
            'description_ar' => $this->descriptionAr,
            'area_en' => $this->areaEn,
            'area_ar' => $this->areaAr,
            'state_id' => $this->stateId,
            'city_id' => $this->cityId,
            'type' => ProjectTypeEnum::PROJECT->value,  
            'project_type_id' => $this->projectTypeId,
            'design_type_id' => $this->designTypeId,
            'budget_id' => $this->budgetId,
            'category_id' => $this->categoryId,
            'status' => ProjectStatusEnum::PUBLISHED->value,
            'user_id' => $userId,
            'country_id' => $this->countryId,
            'sub_category_id' => $this->subCategoryId,
            'tiktok_link' => $this->tiktokLink,
            'sort' => $this->sort,
            
            'price' => $this->price,
            'price_currency' => $this->priceCurrency,
            'total_area' => $this->totalArea,
            'land_area' => $this->landArea,
            'built_area' => $this->builtArea,
            'total_floors' => $this->totalFloors,
            'total_units' => $this->totalUnits,
            'handover_date' => $this->normalizeDate($this->handoverDate),
            'offer_type' => $this->offerType,
            'condition' => $this->condition,
            'has_pool' => $this->hasPool,
            'has_gym' => $this->hasGym,
            'has_parking' => $this->hasParking,
            'furnished' => $this->furnished,
            'down_payment' => $this->downPayment,
            'installments_count' => $this->installmentsCount,
            'installment_amount' => $this->installmentAmount,
            'number_of_bathrooms' => $this->numberOfBathrooms,
            'number_of_rooms' => $this->numberOfRooms ,
            'number_of_beds' => $this->numberOfBeds ,

        ];
    }

    public function projectUpdatePayload(): array
    {
        return array_filter([
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'description_en' => $this->descriptionEn,
            'description_ar' => $this->descriptionAr,
            'area_en' => $this->areaEn,
            'area_ar' => $this->areaAr,
            'state_id' => $this->stateId,
            'city_id' => $this->cityId,
            'type' => $this->type,
            'project_type_id' => $this->projectTypeId,
            'design_type_id' => $this->designTypeId,
            'budget_id' => $this->budgetId,
            'category_id' => $this->categoryId,
            'country_id' => $this->countryId,
            'sub_category_id' => $this->subCategoryId,
            'tiktok_link' => $this->tiktokLink,
            'status' => ProjectStatusEnum::PUBLISHED->value,
                        'sort' => $this->sort,

            'price' => $this->price,
            'price_currency' => $this->priceCurrency,
            'total_area' => $this->totalArea,
            'land_area' => $this->landArea,
            'built_area' => $this->builtArea,
            'total_floors' => $this->totalFloors,
            'total_units' => $this->totalUnits,
            'handover_date' => $this->normalizeDate($this->handoverDate),
            'offer_type' => $this->offerType,
            'condition' => $this->condition,
            'has_pool' => $this->hasPool,
            'has_gym' => $this->hasGym,
            'has_parking' => $this->hasParking,
            'furnished' => $this->furnished,
            'down_payment' => $this->downPayment,
            'installments_count' => $this->installmentsCount,
            'installment_amount' => $this->installmentAmount,
                        'number_of_bathrooms' => $this->numberOfBathrooms,
            'number_of_rooms' => $this->numberOfRooms ,
            'number_of_beds' => $this->numberOfBeds ,

        ], function ($value) {
            return $value !== null;
        });
    }

    public function projectImageInsertPayload(int $projectId): array
    {
        $data = [];
        foreach ($this->images as $image) {
            $data[] = [
                'project_id' => $projectId,
                'image' => $image,
            ];
        }
        return $data;
    }

    public function changeStatusPayload(): array
    {
        return [
            'status' => $this->status
        ];
    }
    private function normalizeDate(?string $date): ?string
{
    if (!$date) return null;

    try {
        return Carbon::createFromFormat('d-m-Y', $date)->format('Y-m-d');
    } catch (\Throwable $e) {
        try {
            return Carbon::parse($date)->format('Y-m-d');
        } catch (\Throwable $e) {
            return null; 
        }
    }
}

}
