<?php

namespace App\Dto\V1;

use Illuminate\Support\Facades\Hash;

class InternalUserDto
{
    public function __construct(
        public ?string $name = null,
        public ?string $email = null,
        public ?bool   $status = null,
        public ?array  $roleIds = [],
        public ?string $password = null,
        public ?string $phoneNumber = null,
    ) {
    }

    /**
     * Payload for create user
     */
    public function createUserPayload(): array
    {
        $data = [
            'name'         => $this->name,
            'email'        => $this->email,
            'status'       => $this->status,
            'phone_number' => $this->phoneNumber,
        ];

        if ($this->password) {
            $data['password'] = Hash::make($this->password);
        }

        return $data;
    }

    /**
     * Payload for update user
     */
    public function updateUserPayload(): array
    {
        $data = [
            'name'         => $this->name,
            'email'        => $this->email,
            'status'       => $this->status,
            'phone_number' => $this->phoneNumber,
        ];

        if ($this->password) {
            $data['password'] = Hash::make($this->password);
        }

        return $data;
    }

    /**
     * Payload for change status only
     */
    public function changeStatusPayload(): array
    {
        return [
            'status' => $this->status,
        ];
    }
}
