<?php

namespace App\Dto\V1;

class FooterTitleDetailDto
{
    public function __construct(
        public ?string $titleEn = null,
        public ?string $titleAr = null,
        public ?bool   $status = null,
        public ?int    $redirectTo = null,
        public ?string $link = null,
        public ?int    $footerTitleId = null,
    )
    {
    }

    public function createPayload(): array
    {
        return [
            'title_en' => $this->titleEn,
            'title_ar' => $this->titleAr,
            'status' => $this->status,
            'redirect_to' => $this->redirectTo,
            'link' => $this->link,
            'footer_title_id' => $this->footerTitleId,
        ];
    }

    public function updatePayload(): array
    {
        return [
            'title_en' => $this->titleEn,
            'title_ar' => $this->titleAr,
            'status' => $this->status,
            'redirect_to' => $this->redirectTo,
            'link' => $this->link,
            'footer_title_id' => $this->footerTitleId,
        ];
    }

    public function changeStatusPayload(): array
    {
        return [
            'status' => $this->status,
        ];
    }
}
