<?php

namespace App\Dto\V1;

class CountryDto
{
    public function __construct(
        public ?string $nameEn = null,
        public ?string $nameAr = null,
        public ?bool $status = null,
    ) {}

    public function createPayload(): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'status' => $this->status,
        ];
    }

    public function updatePayload(): array
    {
        return $this->createPayload();
    }

    public function changeStatusPayload(): array
    {
        return ['status' => $this->status];
    }
}