<?php

namespace App\Dto\V1;

use Illuminate\Http\UploadedFile;

class CategoryDto
{
    public function __construct(
        public ?string       $nameEn = null,
        public ?string       $nameAr = null,
        public ?string       $descriptionEn = null,
        public ?string       $descriptionAr = null,
        public ?bool         $status = null,
        public ?bool         $homeStatus = null,
        public ?bool         $footerVisibility = null,
        public ?UploadedFile $image = null,
        public ?string       $oldImage = null,

    )
    {
    }

    public function createPayload(): array
    {
        return [
            'name_en' => $this->nameEn,
            'name_ar' => $this->nameAr,
            'description_en' => $this->descriptionEn,
            'description_ar' => $this->descriptionAr,
            'status' => $this->status,
            'home_status' => $this->homeStatus,
            'image' => $this->image,
             'footer_visibility' => $this->footerVisibility,
        ];
    }

public function updatePayload(): array
{
    $data = array_filter([
        'name_en' => $this->nameEn,
        'name_ar' => $this->nameAr,
        'description_en' => $this->descriptionEn,
        'description_ar' => $this->descriptionAr,
        'status' => $this->status,
        'home_status' => $this->homeStatus,
        'footer_visibility' => $this->footerVisibility,
    ], fn ($property) => $property !== null);

    if ($this->image) {
        if ($this->oldImage) {
            delete_s3_image($this->oldImage, 'categories/images');
        }

        $data['image'] = upload_s3_images($this->image, 'categories/images');
    }

    return $data;
}


    public function changeStatusPayload(): array
    {
        return array_filter([
            'status' => $this->status,
            'home_status' => $this->homeStatus,
        ], fn($property) => $property !== null);
    }
}
