<?php

namespace App\Actions\V1\Users;

use App\Models\User;
use App\Repositories\V1\Users\UserRepositoryInterface;

readonly class GetUserAction
{
    public function __construct(private UserRepositoryInterface $repository)
    {
    }

    public function execute(int $id): User
    {
        return $this->repository->getById($id);
    }
}
