<?php

namespace App\Actions\V1\Users;

use App\Dto\V1\UserDto;
use App\Repositories\V1\Users\UserRepositoryInterface;

readonly class ChangeUserStatusAction
{
    public function __construct(private UserRepositoryInterface $repository)
    {
    }

    public function execute(UserDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->changeStatusPayload());
    }
}
