<?php

namespace App\Actions\V1\Tags;

use App\Repositories\V1\Tags\TagRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class TagListAction
{
    public function __construct(private TagRepositoryInterface $tagRepository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->tagRepository->index($utility, $limit);
    }
}
