<?php

namespace App\Actions\V1\Tags;

use App\Dto\V1\TagDto;
use App\Repositories\V1\Tags\TagRepositoryInterface;

readonly class ChangeTagStatusAction
{
    public function __construct(private TagRepositoryInterface $tagRepository)
    {
    }

    public function execute(TagDto $dto, int $id): bool
    {
        return $this->tagRepository->update($id, $dto->changeStatusPayload());
    }
}
