<?php

namespace App\Actions\V1\SubCategories;

use Infrastructure\Services\Utilities\Utility;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Repositories\V1\SubCategories\SubCategoryRepositoryInterface;

readonly class SubCategoryListAction
{
    public function __construct(
        private SubCategoryRepositoryInterface $repository
    ) {}

    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
}
