<?php

namespace App\Actions\V1\SubCategories;

use App\Models\SubCategory;
use App\Repositories\V1\SubCategories\SubCategoryRepositoryInterface;

readonly class GetSubCategoryAction
{
    public function __construct(
        private SubCategoryRepositoryInterface $repository
    ) {}

    public function execute(int $id): SubCategory
    {
        return $this->repository->find($id);
    }
}
