<?php

namespace App\Actions\V1\SubCategories;

use App\Repositories\V1\SubCategories\SubCategoryRepositoryInterface;
use Infrastructure\Services\Utilities\Utility;
use Illuminate\Pagination\LengthAwarePaginator;

readonly class GetSubCategoriesByCategoryAction
{
    public function __construct(
        private SubCategoryRepositoryInterface $repository
    ) {}

    public function execute(Utility $utility, int $categoryId, int $limit): LengthAwarePaginator
    {
        return $this->repository->getByCategoryId($utility, $categoryId, $limit);
    }
}