<?php

namespace App\Actions\V1\States;

use App\Models\State;
use App\Repositories\V1\States\StateRepositoryInterface;

readonly class GetStateAction
{
    public function __construct(private StateRepositoryInterface $repository)
    {
    }

    public function execute(int $id): State
    {
        return $this->repository->getById($id);
    }
}
