<?php

namespace App\Actions\V1\States;

use App\Dto\V1\StateDto;
use App\Repositories\V1\States\StateRepositoryInterface;

readonly class ChangeStateStatusAction
{
    public function __construct(private StateRepositoryInterface $repository)
    {
    }

    public function execute(StateDto $dto, int $id): bool
    {
        return $this->repository->update($id, $dto->changeStatusPayload());
    }
}
