<?php

namespace App\Actions\V1\Sliders;

use App\Dto\V1\SliderDto;
use App\Repositories\V1\Sliders\SliderRepositoryInterface;

readonly class UpdateSliderAction
{
    public function __construct(private SliderRepositoryInterface $sliderRepository)
    {
    }

    public function execute(SliderDto $dto, int $id): bool
    {
        $slider = $this->sliderRepository->getById($id);
        return $this->sliderRepository->update($id, $dto->updatePayload($slider->getRawOriginal('image_en'),$slider->getRawOriginal('image_ar')));
    }
}
