<?php

namespace App\Actions\V1\Sliders;

use App\Dto\V1\SliderDto;
use App\Models\Slider;
use App\Repositories\V1\Sliders\SliderRepositoryInterface;

readonly class StoreSliderAction
{
    public function __construct(private SliderRepositoryInterface $sliderRepository)
    {
    }

    public function execute(SliderDto $dto): Slider
    {
        return $this->sliderRepository->create($dto->createPayload());
    }
}
