<?php

namespace App\Actions\V1\Sliders;

use App\Models\Slider;
use App\Repositories\V1\Sliders\SliderRepositoryInterface;

readonly class GetSliderAction
{
    public function __construct(private SliderRepositoryInterface $sliderRepository)
    {
    }

    public function execute(int $id): Slider
    {
        return $this->sliderRepository->getById($id);
    }
}
