<?php

namespace App\Actions\V1\Sliders;

use App\Dto\V1\SliderDto;
use App\Repositories\V1\Sliders\SliderRepositoryInterface;

readonly class ChangeSliderStatusAction
{
    public function __construct(private SliderRepositoryInterface $sliderRepository)
    {
    }

    public function execute(SliderDto $dto, int $id): bool
    {
        return $this->sliderRepository->update($id, $dto->changeStatusPayload());
    }
}
