<?php

namespace App\Actions\V1\Settings;

use App\Repositories\V1\Settings\SettingRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Infrastructure\Services\Utilities\Utility;

readonly class SettingListAction
{
    public function __construct(private SettingRepositoryInterface $repository)
    {
    }
    public function execute(Utility $utility, int $limit): LengthAwarePaginator
    {
        return $this->repository->index($utility, $limit);
    }
    
    public function executeWithoutPagination(Utility $utility)
    {
        return $this->repository->all($utility);
    }
}
