<?php

namespace App\Actions\V1\Roles;

use App\Dto\V1\RoleDto;
use App\Repositories\V1\Roles\PermissionRepositoryInterface;
use Spatie\Permission\Models\Role;

readonly class StoreRoleAction
{
    public function __construct(private PermissionRepositoryInterface $permissionRepository)
    {
    }

    public function execute(RoleDto $dto): Role
    {
        $role = $this->permissionRepository->create($dto->rolePayload());
        $permissions = $this->permissionRepository->getPermissionsByIds($dto->permissionIds);
        $role->syncPermissions($permissions);
        return $role;
    }
}
