<?php

namespace App\Actions\V1\Roles;

use App\Repositories\V1\Roles\PermissionRepositoryInterface;
use Illuminate\Database\Eloquent\Collection;
use Infrastructure\Services\Utilities\Utility;

readonly class RolesListAction
{
    public function __construct(private PermissionRepositoryInterface $permissionRepository)
    {
    }

    public function execute(Utility $utility): Collection
    {
        return $this->permissionRepository->getRoles($utility);
    }

    public function executeWithPagination(Utility $utility, int $limit)
    {
        return $this->permissionRepository->getRolesPaginated($utility, $limit);
    }
}
