<?php

namespace App\Actions\V1\Roles;

use App\Repositories\V1\Roles\PermissionRepositoryInterface;
use Spatie\Permission\Models\Role;

readonly class GetRoleAction
{
    public function __construct(private PermissionRepositoryInterface $permissionRepository)
    {
    }

    public function execute(int $id): Role
    {
        return $this->permissionRepository->getById($id);
    }
}
